package com.ejie.ab04b.service.platea;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejie.ab04b.constantes.ConstantesNum;
import com.ejie.ab04b.util.GatUtils;
import com.ejie.ab04b.util.seguridad.UtilSeguridad;
import com.ejie.ab04b.webservice.client.gat.ArrayOfInt;
import com.ejie.ab04b.webservice.client.gat.ArrayOfString;
import com.ejie.ab04b.webservice.client.gat.Q99UGATFacadeWSSoap;
import com.ejie.gat.xml.MessageListType;

/**
 * @author GFI-NORTE
 *
 */
@Service(value = "gatService")
public class GatService {

	private static final String TASK_PROPERTY_FOLDER_ID = "FOLDERID";

	private static final String TASK_CATEGORY_TRAMITACION = "TRAMITACION";

	private static final Integer TASK_STATUS_PEDIENTE = 1;

	private static final Logger LOGGER = LoggerFactory
			.getLogger(GatService.class);

	@Autowired()
	private Q99UGATFacadeWSSoap q99UGATFacadeWSSoap;

	/**
	 *  folderId
	 *            String
	 * 
	 *  int count.
	 *
	 * @param folderId the folder id
	 * @return the int
	 */
	public int obtenerCountTareasPendientes(String folderId) {

		Object[] args = new Object[] { folderId };
		GatService.LOGGER.info(
				"Buscando tareas pendientes en GAT con folderId {}", args);

		String sSessionToken = UtilSeguridad.getInstance().getTokenXLNets();

		ArrayOfString buzones = new ArrayOfString();

		ArrayOfString categorias = new ArrayOfString();
		categorias.getString().add(GatService.TASK_CATEGORY_TRAMITACION);

		ArrayOfInt estados = new ArrayOfInt();
		estados.getInt(); // para inicializar lista
		estados.getInt().add(GatService.TASK_STATUS_PEDIENTE);

		StringBuilder propiedades = new StringBuilder();
		propiedades.append("<hashMap>");

		propiedades.append("<elements>");
		propiedades.append("<campo>");
		propiedades.append(GatService.TASK_PROPERTY_FOLDER_ID);
		propiedades.append("</campo>");
		propiedades.append("<valor>");
		propiedades.append(folderId);
		propiedades.append("</valor>");
		propiedades.append("</elements>");

		propiedades.append("</hashMap>");

		try {
			String response = this.q99UGATFacadeWSSoap.getGATTasks(
					sSessionToken, buzones, categorias, estados,
					propiedades.toString(), null, null);

			MessageListType messageList = GatUtils.getInstance()
					.getGatResponseAsTask(response);

			if (messageList != null) {
				return messageList.getTotalCount();
			}
			return 0;
		} catch (Exception e) {
			GatService.LOGGER.error("Error al obtener tareas getGATTasks", e);
			return ConstantesNum.NUM_9999;
		}
	}

}
